<?php
/**
 * Function describe for ZenMacrame 
 * 
 * @package zenmacrame
 */

/**
 * Set a constant that holds the theme's minimum supported PHP version.
 */
define( 'ZENMACRAME_MIN_PHP_VERSION', '7.0' );

/**
 * Immediately after theme switch is fired we we want to check php version and
 * revert to previously active theme if version is below our minimum.
 */
add_action( 'after_switch_theme', 'zenmacrame_test_for_min_php' );

/**
 * Switches back to the previous theme if the minimum PHP version is not met.
 */
function zenmacrame_test_for_min_php() {

	// Compare versions.
	if ( version_compare( PHP_VERSION, ZENMACRAME_MIN_PHP_VERSION, '<' ) ) {
		// Site doesn't meet themes min php requirements, add notice...
		add_action( 'admin_notices', 'zenmacrame_min_php_not_met_notice' );
		// ... and switch back to previous theme.
		switch_theme( get_option( 'theme_switched' ) );
		return false;

	};
}

if ( ! function_exists( 'wp_body_open' ) ) {
        function wp_body_open() {
                do_action( 'wp_body_open' );
        }
}

/**
 * An error notice that can be displayed if the Minimum PHP version is not met.
 */
function zenmacrame_min_php_not_met_notice() {
	?>
	<div class="notice notice-error is_dismissable">
		<p>
			<?php esc_html_e( 'You need to update your PHP version to run this theme.', 'zenmacrame' ); ?> <br />
			<?php
			printf(
				/* translators: 1 is the current PHP version string, 2 is the minmum supported php version string of the theme */
				esc_html__( 'Actual version is: %1$s, required version is: %2$s.', 'zenmacrame' ),
				PHP_VERSION,
				ZENMACRAME_MIN_PHP_VERSION
			); // phpcs: XSS ok.
			?>
		</p>
	</div>
	<?php
}


if ( ! function_exists( 'zenmacrame_social_sites_options' ) ) :
	/**
	 * Returns an array with info about social icons displayed in Header and Footer
	 */
	function zenmacrame_social_sites_options() {

		return array (
		    array( 'id' 	=> 'zenmacrame_social_facebook',
		    	   'label'  => __('Facebook', 'zenmacrame'),
		    	   'class'  => 'facebook-icon',
		    	 ),
		    array( 'id' 	=> 'zenmacrame_social_twitter',
		    	   'label'  => __('Twitter', 'zenmacrame'),
		    	   'class'  => 'twitter-icon',
		    	 ),
		    array( 'id' 	=> 'zenmacrame_social_linkedin',
		    	  'label'   => __('LinkedIn', 'zenmacrame'),
		    	  'class'   => 'linkedin-icon',
		    	 ),
		    array( 'id' 	=> 'zenmacrame_social_instagram',
		    	   'label'  => __('Instagram', 'zenmacrame'),
		    	   'class'  => 'instagram-icon',
		    	 ),
		    array( 'id' 	=> 'zenmacrame_social_rss',
		    	   'label'  => __('RSS Feeds', 'zenmacrame'),
		    	   'class'  => 'rss-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_tumblr',
		    	   'label'  => __('Tumblr', 'zenmacrame'),
		    	   'class'  => 'tumblr-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_youtube',
		    	   'label'  => __('YouTube channel', 'zenmacrame'),
		    	   'class'  => 'youtube-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_pinterest',
		    	   'label'  => __('Pinterest', 'zenmacrame'),
		    	   'class'  => 'pinterest-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_vk',
		    	   'label'  => __('VK', 'zenmacrame'),
		    	   'class'  => 'vk-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_flickr',
		    	   'label'  => __('Flickr', 'zenmacrame'),
		    	   'class'  => 'flickr-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_vine',
		    	   'label'  => __('Vine', 'zenmacrame'),
		    	   'class'  => 'vine-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_github',
		    	   'label'  => __('GitHub', 'zenmacrame'),
		    	   'class'  => 'github-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_bitbucket',
		    	   'label'  => __('BitBucket', 'zenmacrame'),
		    	   'class'  => 'bitbucket-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_reddit',
		    	   'label'  => __('Reddit', 'zenmacrame'),
		    	   'class'  => 'reddit-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_xing',
		    	   'label'  => __('Xing', 'zenmacrame'),
		    	   'class'  => 'xing-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_slack',
		    	   'label'  => __('Slack', 'zenmacrame'),
		    	   'class'  => 'slack-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_wechat',
		    	   'label'  => __('WeChat', 'zenmacrame'),
		    	   'class'  => 'wechat-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_snapchat',
		    	   'label'  => __('SnapChat', 'zenmacrame'),
		    	   'class'  => 'snapchat-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_dribbble',
		    	   'label'  => __('Dribbble', 'zenmacrame'),
		    	   'class'  => 'dribbble-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_bandcamp',
		    	   'label'  => __('Bandcamp', 'zenmacrame'),
		    	   'class'  => 'bandcamp-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_lastfm',
		    	   'label'  => __('Last.fm', 'zenmacrame'),
		    	   'class'  => 'lastfm-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_soundcloud',
		    	   'label'  => __('SoundCloud', 'zenmacrame'),
		    	   'class'  => 'soundcloud-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_vimeo',
		    	   'label'  => __('Vimeo', 'zenmacrame'),
		    	   'class'  => 'vine-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_skype',
		    	   'label'  => __('Skype', 'zenmacrame'),
		    	   'class'  => 'skype-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_deviantart',
		    	   'label'  => __('DeviantArt', 'zenmacrame'),
		    	   'class'  => 'deviantart-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_yahoo',
		    	   'label'  => __('Yahoo', 'zenmacrame'),
		    	   'class'  => 'yahoo-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_amazon',
		    	   'label'  => __('Amazon', 'zenmacrame'),
		    	   'class'  => 'amazon-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_etsy',
		    	   'label'  => __('Etsy', 'zenmacrame'),
		    	   'class'  => 'etsy-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_foursquare',
		    	   'label'  => __('Foursquare', 'zenmacrame'),
		    	   'class'  => 'foursquare-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_quora',
		    	   'label'  => __('Quora', 'zenmacrame'),
		    	   'class'  => 'quora-icon',
		    	 ),
		    array( 'id'     => 'zenmacrame_social_yelp',
		    	   'label'  => __('Yelp', 'zenmacrame'),
		    	   'class'  => 'yelp-icon',
		    	 ),
		);
	}

endif; // zenmacrame_social_sites_options



if ( ! function_exists( 'zenmacrame_load_css_and_scripts' ) ) :

	function zenmacrame_load_css_and_scripts() {

		// Load CSS Styles
		wp_enqueue_style( 'zenmacrame-stylesheet', get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'zenmacrame-child-style', get_stylesheet_uri(), array( 'zenmacrame-stylesheet' ) );


		// Load JavaScripts
		wp_enqueue_script( 'materialize-js',
			get_stylesheet_directory_uri() . '/assets/js/materialize.js',
			array('jquery') );

		wp_enqueue_script( 'zenmacrame-js',
			get_stylesheet_directory_uri() . '/assets/js/zenmacrame.js',
			array( 'jquery', 'materialize-js' ) );
	}

endif; // zenmacrame_load_css_and_scripts

add_action( 'wp_enqueue_scripts', 'zenmacrame_load_css_and_scripts' );

/**
 * Displays the slider
 */
if ( ! function_exists( 'zenmacrame_display_slider' ) ) :

	function zenmacrame_display_slider() {
	?>
		<div class="slider">
    		<ul class="slides">
			<?php
				// display slides
				for ( $i = 1; $i <= 3; ++$i ) {

						$slideContent = get_theme_mod( 'zenmacrame_slide'.$i.'_content' );
						$slideImage = get_theme_mod( 'zenmacrame_slide'.$i.'_image' );
					?>
						<?php if ( !empty($slideImage) ) : ?>

								<li>
							        <img src="<?php echo esc_attr( $slideImage ); ?>">
							        <div class="caption left-align">
							          	<?php echo $slideContent; ?>
							        </div>
							    </li>

						<?php endif; ?>
	<?php		}

?>
			</ul>
		</div>
	<?php 
	}

endif; // zenmacrame_display_slider

if ( ! function_exists( 'zenmacrame_sanitize_checkbox' ) ) :

	function zenmacrame_sanitize_checkbox( $checked ) {
		// Boolean check.
		return ( ( isset( $checked ) && true == $checked ) ? true : false );
	}

endif; // zenmacrame_sanitize_checkbox

if ( ! function_exists( 'zenmacrame_sanitize_url' ) ) :

	function zenmacrame_sanitize_url( $url ) {
		return esc_url_raw( $url );
	}

endif; // zenmacrame_sanitize_url

if ( ! function_exists( 'zenmacrame_sanitize_html' ) ) :

	function zenmacrame_sanitize_html( $html ) {
		return wp_kses_post( $html );
	}

endif; // zenmacrame_sanitize_html

if ( ! function_exists( 'zenmacrame_sanitize_image' ) ) :

	function zenmacrame_sanitize_image( $image, $setting ) {
		/*
		 * Array of valid image file types.
		 *
		 * The array includes image mime types that are included in wp_get_mime_types()
		 */
	    $mimes = array(
	        'jpg|jpeg|jpe' => 'image/jpeg',
	        'gif'          => 'image/gif',
	        'png'          => 'image/png',
	        'bmp'          => 'image/bmp',
	        'tif|tiff'     => 'image/tiff',
	        'ico'          => 'image/x-icon'
	    );
		// Return an array with file extension and mime_type.
	    $file = wp_check_filetype( $image, $mimes );
		// If $image has a valid mime_type, return it; otherwise, return the default.
	    return ( $file['ext'] ? $image : $setting->default );
	}

endif; // zenmacrame_sanitize_image

if ( ! class_exists( 'zenmacrame_Customize' ) ) :

	/**
	 * Singleton class for handling the theme's customizer integration.
	 */
	final class zenmacrame_Customize {

		// Returns the instance.
		public static function get_instance() {

			static $instance = null;

			if ( is_null( $instance ) ) {
				$instance = new self;
				$instance->setup_actions();
			}

			return $instance;
		}

		// Constructor method.
		private function __construct() {}

		// Sets up initial actions.
		private function setup_actions() {

			// Register panels, sections, settings, controls, and partials.
			add_action( 'customize_register', array( $this, 'sections' ) );

			// Register scripts and styles for the controls.
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
		}

		// Sets up the customizer sections.
		public function sections( $manager ) {

			// Load custom sections.

			// Register custom section types.
			$manager->register_section_type( 'zenlife_Customize_Section_Pro' );

			// Register sections.
			$manager->add_section(
				new zenlife_Customize_Section_Pro(
					$manager,
					'zenmacrame',
					array(
						'title'    => esc_html__( 'ZenMacramePro', 'zenmacrame' ),
						'pro_text' => esc_html__( 'Upgrade', 'zenmacrame' ),
						'pro_url'  => esc_url( 'https://zentemplates.com/product/zenmacramepro' )
					)
				)
			);
		}

		// Loads theme customizer CSS.
		public function enqueue_control_scripts() {

			wp_enqueue_script( 'zenlife-customize-controls', trailingslashit( get_template_directory_uri() ) . 'js/customize-controls.js', array( 'customize-controls' ) );

			wp_enqueue_style( 'zenlife-customize-controls', trailingslashit( get_template_directory_uri() ) . 'css/customize-controls.css' );
		}
	}

endif; // zenmacrame_Customize

// Doing this customizer thang!
zenmacrame_Customize::get_instance();

/**
 * Remove Parent theme Customize Up-Selling Section
 */
if ( ! function_exists( 'zenmacrame_remove_parent_theme_upsell_section' ) ) :

	function zenmacrame_remove_parent_theme_upsell_section( $wp_customize ) {

		// Remove Parent-Theme Upsell section
		$wp_customize->remove_section('zenlife');
	}

endif; // zenmacrame_remove_parent_theme_upsell_section

add_action( 'customize_register', 'zenmacrame_remove_parent_theme_upsell_section', 100 );

if ( ! function_exists( 'zenmacrame_show_social_sites' ) ) :

	function zenmacrame_show_social_sites() {

		$socialSitesOptions = zenmacrame_social_sites_options();
		foreach ($socialSitesOptions as $socialSitesOption) {

			$socialSiteId = $socialSitesOption['id'];
			$socialSiteLabel = $socialSitesOption['label'];
			$socialSiteCSS = $socialSitesOption['class'];

			$socialURL = get_theme_mod($socialSiteId);
			if ( !empty($socialURL) ) {

				echo '<li><a href="' . esc_url( $socialURL )
						. '" title="' . esc_attr( $socialSiteLabel )
						. '" class="' . esc_attr( $socialSiteCSS )
						. '"></a></li>';
			}
		}
	}
endif; // zenmacrame_show_social_sites

if ( ! function_exists( 'zenmacrame_customize_register' ) ) :

	/**
	 * Register theme settings in the customizer
	 */
	function zenmacrame_customize_register( $wp_customize ) {

		/**
		 * Add Slider Section
		 */
		$wp_customize->add_section(
			'zenmacrame_slider_section',
			array(
				'title'       => __( 'Slider', 'zenmacrame' ),
				'capability'  => 'edit_theme_options',
			)
		);

		// Add display slider option
		$wp_customize->add_setting(
				'zenmacrame_slider_display',
				array(
						'default'           => 0,
						'sanitize_callback' => 'zenmacrame_sanitize_checkbox',
				)
		);

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'zenmacrame_slider_display',
								array(
									'label'          => __( 'Display Slider on a Static Front Page', 'zenmacrame' ),
									'section'        => 'zenmacrame_slider_section',
									'settings'       => 'zenmacrame_slider_display',
									'type'           => 'checkbox',
								)
							)
		);
		
		for ($i = 1; $i <= 3; ++$i) {
		
			$slideContentId = 'zenmacrame_slide'.$i.'_content';
			$slideImageId = 'zenmacrame_slide'.$i.'_image';
			$defaultSliderImagePath = esc_url(get_stylesheet_directory_uri() . '/assets/images/slider/' . $i . '.jpg');
		
			// Add Slide Content
			$wp_customize->add_setting(
				$slideContentId,
				array(
					'sanitize_callback' => 'zenmacrame_sanitize_html',
				)
			);
			
			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, $slideContentId,
										array(
											'label'          => sprintf( esc_html__( 'Slide #%s Content', 'zenmacrame' ), $i ),
											'section'        => 'zenmacrame_slider_section',
											'settings'       => $slideContentId,
											'type'           => 'textarea',
											)
										)
			);
			
			// Add Slide Background Image
			$wp_customize->add_setting( $slideImageId,
				array(
					'default' => $defaultSliderImagePath,
					'sanitize_callback' => 'zenmacrame_sanitize_image'
				)
			);

			$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $slideImageId,
					array(
						'label'   	 => sprintf( esc_html__( 'Slide #%s Image', 'zenmacrame' ), $i ),
						'section' 	 => 'zenmacrame_slider_section',
						'settings'   => $slideImageId,
					) 
				)
			);
		}

		/**
		 * Add Social Sites Section
		 */
		$wp_customize->add_section(
			'zenmacrame_social_section',
			array(
				'title'       => __( 'Social Sites', 'zenmacrame' ),
				'capability'  => 'edit_theme_options',
			)
		);

		$socialSitesOptions = zenmacrame_social_sites_options();
		foreach ($socialSitesOptions as $socialSitesOption) {

			$socialSiteId = $socialSitesOption['id'];
			$socialSiteLabel = $socialSitesOption['label'];

			// Add Social Site Customizer Option
			$wp_customize->add_setting(
				$socialSiteId,
				array(
				    'sanitize_callback' => 'zenmacrame_sanitize_url',
				)
			);

			$wp_customize->add_control( new WP_Customize_Control( $wp_customize, $socialSiteId,
		        array(
		            'label'          => $socialSiteLabel,
		            'section'        => 'zenmacrame_social_section',
		            'settings'       => $socialSiteId,
		            'type'           => 'text',
		            )
		        )
			);	
		}
	}
endif; // zenmacrame_customize_register

add_action('customize_register', 'zenmacrame_customize_register');


if ( ! function_exists( 'zenmacrame_setup' ) ) :
	/**
	 * zenmacrame setup.
	 *
	 * Set up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support post thumbnails.
	 *
	 */
	function zenmacrame_setup() {

		// Define and register starter content to showcase the theme on new sites.
		$starter_content = array(

			'widgets' => array(
				'sidebar-widget-area' => array(
					'search',
					'recent-posts',
					'categories',
					'archives',
				),

				

				'footer-column-1-widget-area' => array(
					'recent-comments'
				),

				'footer-column-2-widget-area' => array(
					'recent-posts'
				),

				'footer-column-3-widget-area' => array(
					'calendar'
				),
			),

			'posts' => array(
				'home',
				'blog',
				'about',
				'contact'
			),

			// Default to a static front page and assign the front and posts pages.
			'options' => array(
				'show_on_front' => 'page',
				'page_on_front' => '{{home}}',
				'page_for_posts' => '{{blog}}',
			),

			// Set the front page section theme mods to the IDs of the core-registered pages.
			'theme_mods' => array(
				'zenmacrame_slider_display' => 1,
				'zenmacrame_slide1_image' => esc_url( get_stylesheet_directory_uri() . '/assets/images/slider/1.jpg' ),
				'zenmacrame_slide1_content' => _x( '<h2>Slide 1 Title</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p><a href="#" title="Read more" class="btn">Read more</a>', 'Theme starter content', 'zenmacrame' ),
				'zenmacrame_slide2_image' => esc_url( get_stylesheet_directory_uri() . '/assets/images/slider/2.jpg' ),
				'zenmacrame_slide2_content' => _x( '<h2>Slide 2 Title</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p><a href="#" title="Read more" class="btn">Read more</a>', 'Theme starter content', 'zenmacrame' ),
				'zenmacrame_slide3_image' => esc_url( get_stylesheet_directory_uri() . '/assets/images/slider/3.jpg' ),
				'zenmacrame_slide3_content' => _x( '<h2>Slide 3 Title</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p><a href="#" title="Read more" class="btn">Read more</a>', 'Theme starter content', 'zenmacrame' ),
			),

			'nav_menus' => array(

				// Assign a menu to the "primary" location.
				'primary' => array(
					'name' => __( 'Primary Menu', 'zenmacrame' ),
					'items' => array(
						'link_home',
						'page_blog',
						'page_contact',
						'page_about',
					),
				),

				// Assign a menu to the "footer" location.
				'footer' => array(
					'name' => __( 'Footer Menu', 'zenmacrame' ),
					'items' => array(
						'link_home',
						'page_blog',
						'page_contact',
						'page_about',
					),
				),
			),
		);

		$starter_content = apply_filters( 'zenmacrame_starter_content', $starter_content );
		add_theme_support( 'starter-content', $starter_content );	
	}
endif; // zenmacrame_setup
add_action( 'after_setup_theme', 'zenmacrame_setup' );

/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @link https://git.io/vWdr2
 */
function zenmacrame_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test(navigator.userAgent)&&document.getElementById&&window.addEventListener&&window.addEventListener("hashchange",function(){var t,e=location.hash.substring(1);/^[A-z0-9_-]+$/.test(e)&&(t=document.getElementById(e))&&(/^(?:a|select|input|button|textarea)$/i.test(t.tagName)||(t.tabIndex=-1),t.focus())},!1);
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'zenmacrame_skip_link_focus_fix' );
