<?php
/**
 * Theme About Page
 *
 * @package Soundscape
 * @since 1.0
 */

function soundscape_theme_page_admin_style( $hook ) {
	if ( 'appearance_page_soundscape-theme' === $hook ) {
		// Register theme stylesheet.
		$theme_version = wp_get_theme()->get( 'Version' );

		$version_string = is_string( $theme_version ) ? $theme_version : false;
		wp_enqueue_style(
			'soundscape-theme-admin-style',
			get_theme_file_uri( 'assets/css/about-admin.css' ),
			array(),
			$version_string
		);
	}
}
add_action( 'admin_enqueue_scripts', 'soundscape_theme_page_admin_style' );

/**
 * Add theme page
 */
function soundscape_menu() {
	add_theme_page( esc_html__( 'Soundscape', 'soundscape' ), esc_html__( 'Soundscape', 'soundscape' ), 'edit_theme_options', 'soundscape-theme', 'soundscape_theme_page_display' );
}
add_action( 'admin_menu', 'soundscape_menu' );

/**
 * Display About page
 */
function soundscape_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	}
	?>

	<div id="welcome-panel" class="welcome-panel">
		<div class="welcome-panel-content">
			<div class="welcome-panel-header">
				<h2><?php echo esc_html( $theme->Name ); ?></h2>
				<p><?php esc_html_e( 'Full Site Editing WordPress Theme', 'soundscape' ); ?></p>
			</div>

			<div class="welcome-panel-column-container">
				<div class="container-wrap">
					<div class="welcome-panel-column two-columns">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'Getting Started with Soundscape!', 'soundscape' ); ?></h3>
							<p><?php esc_html_e( 'Awesome! Soundscape has been installed and activated successfully. Now, you can start building your dream website with a wide range of highly-customizable block patterns, templates, and template parts available in this astounding theme.', 'soundscape' ); ?></p>
							<a target="_blank" href="https://catchthemes.com/themes/soundscape/#theme-instructions"><?php esc_html_e( 'Theme documentation', 'soundscape' ); ?></a>
						</div>
					</div>

					<div class="welcome-panel-column two-columns">
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e( 'More Features with FSE Pro plugin', 'soundscape' ); ?></h3>
							<p><?php esc_html_e( 'To get more beautiful block patterns and templates, we recommend you activate the FSE Pro plugin by Catch Themes. With the plugin installed, get more options, blocks, block patterns, templates and template parts.', 'soundscape' ); ?></p>
							<p><?php esc_html_e( 'FSE Pro plugin is bundled with the theme when pro theme is purchased. Install the zip file to get more features.', 'soundscape' ); ?></p>
						</div>
					</div>
				</div>
				<div class="sidebar">
					<div class="welcome-panel-column important-links">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Important Links', 'soundscape' ); ?></h3>
						<a target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) ); ?>"><?php esc_html_e( 'Theme Info', 'soundscape' ); ?></a>
						<a target="_blank" href="https://fse.catchthemes.com/soundscape"><?php esc_html_e( 'View Demo', 'soundscape' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#theme-instructions' ); ?>"><?php esc_html_e( 'Theme Instructions', 'soundscape' ); ?></a>
						<a  target="_blank" href="<?php echo esc_url( $theme->get( 'ThemeURI' ) . '/#changelog' ); ?>"><?php esc_html_e( 'Change log', 'soundscape' ); ?></a>
						<a target="_blank" href="<?php echo esc_url( 'https://catchthemes.com/support-forum/forum/full-site-editing/' ); ?>"><?php esc_html_e( 'Support', 'soundscape' ); ?></a>
					</div>
				</div>

				<div class="welcome-panel-column review">
					<!-- <div class="welcome-panel-icon-pages"></div> -->
					<div class="welcome-panel-column-content">
						<h3><?php esc_html_e( 'Leave us a review', 'soundscape' ); ?></h3>
						<p><?php esc_html_e( 'Loved BizBoost? Feel free to leave your feedback. Your opinion helps us reach more audiences!', 'soundscape' ); ?></p>
						<a href="https://wordpress.org/support/theme/soundscape/reviews/" class="button button-primary button-hero" style="text-decoration: none;" target="_blank"><?php esc_html_e( 'Review', 'soundscape' ); ?></a>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
