<?php
/**
 * Subscribe section
 *
 * This is the template for the content of top subscribe section
 *
 * @package Theme Palace
 * @subpackage Businesszen Dairy
 * @since Businesszen Dairy 1.0.0
 */
if ( ! function_exists( 'businesszen_dairy_add_subscribe_section' ) ) :
    /**
    * Add top subscribe section
    *
    *@since Businesszen Dairy 1.0.0
    */
    function businesszen_dairy_add_subscribe_section() {
      
        // Check if subscribe is enabled on frontpage
        if ( get_theme_mod( 'subscribe_section_enable' ) == false ) {
            return false;
        }

        // Render top subscribe section now.
        businesszen_dairy_render_subscribe_section();
    }
endif;

if ( ! function_exists( 'businesszen_dairy_render_subscribe_section' ) ) :
  /**
   * Start top subscribe section
   *
   * @return string top subscribe content
   * @since Businesszen Dairy 1.0.0
   *
   */
   function businesszen_dairy_render_subscribe_section() {
        if ( ! class_exists( 'Jetpack' ) ) {
           return;
        } elseif ( class_exists( 'Jetpack' ) ) {
            if ( ! Jetpack::is_module_active( 'subscriptions' ) )
               return;
        }

        $bg_image = ! empty(  get_theme_mod( 'subscription_bg_image' ) ) ?  get_theme_mod( 'subscription_bg_image' ) : '';
        ?>

        <div id="businesszen_subscribe_section" class="relative page-section" style="background-image: url('<?php echo esc_url( $bg_image); ?>');">
          <div class="overlay"></div>
          <div class="wrapper">
            <?php if( !empty( get_theme_mod( 'subscription_title', __( 'Subscribe Now', 'businesszen-dairy' ) ) ) ): ?>
              <header class="entry-header">
                <h2 class="entry-title"><?php echo esc_html( get_theme_mod( 'subscription_title', __( 'Subscribe Now', 'businesszen-dairy' ) ) ); ?></h2>
              </header>
            <?php endif; ?>

            <div class="entry-content">
              <p><?php echo esc_html( get_theme_mod( 'subscription_description', __( 'Almost two years ago I sat down in front of a computer screen, in an open office space, waiting. I was nervous, eager to start and terrified.', 'businesszen-dairy' ) ) ); ?></p>
            </div><!-- .entry-content -->

            <div class="jetpack_subscription_widget"><h2 class="widgettitle"></h2>
              <?php 
              $subscribe_shortcode = '[jetpack_subscription_form title="" subscribe_text="" subscribe_button="' . esc_html( get_theme_mod( 'subscription_btn_title', __( 'Subscribe', 'businesszen-dairy' ) ) ) . '" show_subscribers_total="0"]';
              echo do_shortcode( wp_kses_post( $subscribe_shortcode ) ); 
              ?>
            </div><!-- .jetpack_subscription_widget -->
          </div><!-- .wrapper -->
        </div><!-- #businesszen_subscribe_section -->
    <?php }
endif; 