<?php
/**
 * Recent Posts section
 *
 * This is the template for the content of recent_posts section
 *
 * @package Theme Palace
 * @subpackage Businesszen Dairy
 * @since Businesszen Dairy 1.0.0
 */
if ( ! function_exists( 'businesszen_dairy_add_recent_posts_section' ) ) :
    /**
    * Add recent_posts section
    *
    *@since Businesszen Dairy 1.0.0
    */
    function businesszen_dairy_add_recent_posts_section() {
        
        // Check if recent_posts is enabled on frontpage
        if ( get_theme_mod( 'recent_posts_section_enable' ) == false ) {
            return false;
        }

        // Get recent_posts section details
        $section_details = array();
        $section_details = apply_filters( 'businesszen_dairy_filter_recent_posts_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render recent_posts section now.
        businesszen_dairy_render_recent_posts_section( $section_details );
    }

endif;

if ( ! function_exists( 'businesszen_dairy_get_recent_posts_section_details' ) ) :
    /**
    * recent_posts section details.
    *
    * @since Businesszen Dairy 1.0.0
    * @param array $input recent_posts section details.
    */
    function businesszen_dairy_get_recent_posts_section_details( $input ) {
        $content  = array();
        $post_ids = array();
        for ( $i = 1; $i <= 3; $i++ ) {
            if ( ! empty( get_theme_mod( 'recent_posts_content_post_'.$i ) ) )
                $post_ids[] = get_theme_mod( 'recent_posts_content_post_'.$i );
        }

        $args = array(
            'post_type'         => 'post',
            'post__in'          => ( array ) $post_ids,
            'posts_per_page'    => absint( 3 ),
            'orderby'           => 'post__in',
        );

            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) : 
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = businesszen_trim_content( 25 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : get_template_directory_uri() . '/assets/uploads/no-featured-image-590x650.jpg';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
            
        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// recent_posts section content details.
add_filter( 'businesszen_dairy_filter_recent_posts_section_details', 'businesszen_dairy_get_recent_posts_section_details' );


if ( ! function_exists( 'businesszen_dairy_render_recent_posts_section' ) ) :
  /**
   * Start recent_posts section
   *
   * @return string recent_posts content
   * @since Businesszen Dairy 1.0.0
   *
   */
   function businesszen_dairy_render_recent_posts_section( $content_details = array() ) {

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="businesszen_recent_posts_section" class="relative page-section">
            <div class="wrapper">
                <?php if( !empty( get_theme_mod( 'recent_posts_sub_title', __( 'Recent Posts', 'businesszen-dairy' ) ) ) || !empty( get_theme_mod( 'recent_posts_title', __( 'Lighting to Create Art', 'businesszen-dairy' ) ) ) ): ?>
                    <div class="section-header">
                        <?php if( !empty( get_theme_mod( 'recent_posts_sub_title', __( 'Recent Posts', 'businesszen-dairy' ) ) ) ): ?>
                        <p class="section-subtitle"><?php echo esc_html( get_theme_mod( 'recent_posts_sub_title', __( 'Recent Posts', 'businesszen-dairy' ) ) ); ?></p>
                        <?php endif; ?>
                        <?php if( !empty( get_theme_mod( 'recent_posts_title', __( 'Lighting to Create Art', 'businesszen-dairy' ) ) ) ): ?>
                        <h2 class="section-title"><?php echo esc_html( get_theme_mod( 'recent_posts_title', __( 'Lighting to Create Art', 'businesszen-dairy' ) ) ); ?></h2>
                        <?php endif; ?>
                    </div><!-- .section-header -->
                <?php endif; ?>

                <div class="archive-blog-wrapper col-3 clear">
                     <?php foreach ($content_details as $content ): ?>
                        <article>
                            <div class="post-wrapper">
                                <div class="featured-image">
                                    <a href="#"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="blog"></a>
                                </div><!-- .featured-image -->

                                <div class="entry-container">
                                    <div class="entry-meta">
                                        <span class="cat-links">
                                            <?php the_category( '', '', $content['id'] ); ?>
                                        </span>

                                        <?php businesszen_posted_on( $content['id'] ) ; ?>
                                    </div><!-- .entry-meta -->

                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?></a></h2>
                                    </header>

                                    <div class="entry-content">
                                        <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                    </div><!-- .entry-content -->

                                    <?php if( !empty($content['url'] ) ) : ?>
                                        <div class="read-more">
                                            <a href="<?php echo esc_url( $content['url'] );?>" class="btn"><?php echo esc_html( get_theme_mod( 'recent_posts_btn_title', __( 'Read More', 'businesszen-dairy' ) ) ); ?></a>
                                        </div><!-- .read-more -->
                                    <?php endif; ?>
                                </div><!-- .entry-container -->
                            </div><!-- .post-wrapper -->
                        </article>
                    <?php endforeach; ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
        </div><!-- #businesszen_recent_posts_section -->
              
<?php    }
endif;