<?php
/**
 * Recent Posts Section options
 *
 * @package Theme Palace
 * @subpackage Businesszen Dairy
 * @since Businesszen Dairy 1.0.0
 */

// Add Recent Posts section
$wp_customize->add_section( 'businesszen_recent_posts_section',
    array(
        'title'             => esc_html__( 'Recent Posts','businesszen-dairy' ),
        'description'       => esc_html__( 'Recent Posts Section options.', 'businesszen-dairy' ),
        'panel'             => 'businesszen_front_page_panel',
        'priority'          => 51,
    )
);

// Recent Posts content enable control and setting
$wp_customize->add_setting( 'recent_posts_section_enable',
    array(
        'default'           =>  false,
        'sanitize_callback' => 'businesszen_sanitize_switch_control',
    )
);

$wp_customize->add_control( new Businesszen_Dairy_Switch_Control( $wp_customize,
    'recent_posts_section_enable',
        array(
            'label'             => esc_html__( 'Recent Posts Section Enable', 'businesszen-dairy' ),
            'section'           => 'businesszen_recent_posts_section',
            'on_off_label'      => businesszen_switch_options(),
        ) 
    )
);

// latest_post title setting and control
$wp_customize->add_setting( 'recent_posts_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'Lighting to Create Art', 'businesszen-dairy' ),
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'recent_posts_title',
    array(
        'label'             => esc_html__( 'Section Title', 'businesszen-dairy' ),
        'section'           => 'businesszen_recent_posts_section',
        'active_callback'   => 'businesszen_dairy_is_recent_posts_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('recent_posts_title',
        array(
            'selector'            => '#businesszen_recent_posts_section .section-header h2.section-title',
            'settings'            => 'recent_posts_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'businesszen_dairy_recent_posts_title_partial',
        )
    );
}

// latest_post title setting and control
$wp_customize->add_setting( 'recent_posts_sub_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'Recent Posts', 'businesszen-dairy' ),
        'transport'         => 'postMessage',
    )
);

$wp_customize->add_control( 'recent_posts_sub_title',
    array(
        'label'             => esc_html__( 'Section Sub Title', 'businesszen-dairy' ),
        'section'           => 'businesszen_recent_posts_section',
        'active_callback'   => 'businesszen_dairy_is_recent_posts_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('recent_posts_sub_title',
        array(
            'selector'            => '#businesszen_recent_posts_section .section-header p.section-subtitle',
            'settings'            => 'recent_posts_sub_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'businesszen_dairy_recent_posts_sub_title_partial',
        )
    );
}

for ( $i = 1; $i <= 3; $i++ ) :

    // latest_post posts drop down chooser control and setting
    $wp_customize->add_setting( 'recent_posts_content_post_' . $i,
        array(
            'sanitize_callback' => 'businesszen_sanitize_page',
        )
    );

    $wp_customize->add_control( new Businesszen_Dairy_Dropdown_Chooser( $wp_customize,
        'recent_posts_content_post_' . $i,
            array(
                'label'             => sprintf( esc_html__( 'Select Post %d', 'businesszen-dairy' ), $i ),
                'section'           => 'businesszen_recent_posts_section',
                'choices'           => businesszen_post_choices(),
                'active_callback'   => 'businesszen_dairy_is_recent_posts_section_enable',
            ) 
        )
    );

    //latest_post separator
    $wp_customize->add_setting('recent_posts_separator'. $i,
        array(
            'sanitize_callback'      => 'businesszen_sanitize_html',
        )
    );

    $wp_customize->add_control(new Businesszen_Dairy_Customize_Horizontal_Line($wp_customize,
        'recent_posts_separator'. $i,
            array(
                'active_callback'       => 'businesszen_dairy_is_recent_posts_section_enable',
                'type'                  =>'hr',
                'section'               =>'businesszen_recent_posts_section',
            )
        )
    );
    
endfor;

// latest_post title setting and control
$wp_customize->add_setting( 'recent_posts_btn_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'Button Text', 'businesszen-dairy' ),
        'transport'         => 'postMessage',
        'priority'          => 999,
    )
);

$wp_customize->add_control( 'recent_posts_btn_title',
    array(
        'label'             => esc_html__( 'Button Title', 'businesszen-dairy' ),
        'section'           => 'businesszen_recent_posts_section',
        'active_callback'   => 'businesszen_dairy_is_recent_posts_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('recent_posts_btn_title',
        array(
            'selector'            => '#businesszen_recent_posts_section .section-header h2',
            'settings'            => 'recent_posts_btn_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'blogmax_news_most_viewed_posts_title_partial',
        )
    );
}