<?php
// cta title setting and control
$wp_customize->add_setting( 'cta_btn_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => esc_html__( 'View Stories', 'businesszen-dairy' ),
        'transport'         => 'postMessage',
        'priority'          => 999,
    )
);

$wp_customize->add_control( 'cta_btn_title',
    array(
        'label'             => esc_html__( 'Button Title', 'businesszen-dairy' ),
        'section'           => 'businesszen_call_to_action_section',
        'active_callback'   => 'businesszen_is_cta_section_enable',
        'type'              => 'text',
    )
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial('cta_btn_title',
        array(
            'selector'            => '#businesszen_call_to_action_section .read-more a',
            'settings'            => 'cta_btn_title',
            'container_inclusive' => false,
            'fallback_refresh'    => true,
            'render_callback'     => 'businesszen_dairy_cta_btn_title_partial',
        )
    );
}

 // about btn link setting and control
$wp_customize->add_setting( 'cta_btn_url', array(
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'cta_btn_url', array(
    'label'             => esc_html__( 'Button Url', 'businesszen-dairy' ),
    'section'           => 'businesszen_call_to_action_section',
    'active_callback'   => 'businesszen_is_cta_section_enable',
    'type'              => 'url',
) );