<?php

if ( ! function_exists( 'businesszen_dairy_enqueue_styles' ) ) :

	function businesszen_dairy_enqueue_styles() {
		wp_enqueue_style( 'businesszen-dairy-style-parent', get_template_directory_uri() . '/style.css' );

		wp_enqueue_style( 'businesszen-dairy-style', get_stylesheet_directory_uri() . '/style.css', array( 'businesszen-dairy-style-parent' ), '1.0.0' );

		wp_enqueue_style( 'businesszen-dairy-gray-css', get_stylesheet_directory_uri() . '/assets/css/gray.css' );

	}

endif;

add_action( 'wp_enqueue_scripts', 'businesszen_dairy_enqueue_styles', 99 );

require get_theme_file_path() . '/inc/customizer.php';

function businesszen_dairy_customize_control_style() {


	wp_enqueue_style( 'businesszen-dairy-customize-controls', get_theme_file_uri() . '/customizer-control.css' );

}
add_action( 'customize_controls_enqueue_scripts', 'businesszen_dairy_customize_control_style' );

require get_theme_file_path() . '/inc/front-sections/featured-posts.php';
require get_theme_file_path() . '/inc/front-sections/popular-posts.php';
require get_theme_file_path() . '/inc/front-sections/cta.php';
require get_theme_file_path() . '/inc/front-sections/recent-posts.php';
require get_theme_file_path() . '/inc/front-sections/subscribe.php';

/* register siderbar for popular posts section */

function businesszen_dairy_widgets_init() {
	$options = businesszen_get_theme_options();
	register_sidebar( array(
		'name'          => esc_html__( 'Popular Posts Sidebar', 'businesszen-dairy' ),
		'id'            => 'popular-posts-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'businesszen-dairy' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

}
add_action( 'widgets_init', 'businesszen_dairy_widgets_init' );