<?php

	if (!empty($_POST)) {
		// email recipient
		define('EMAIL_RECIPIENT', 'elizart@free.fr'); // the email address where you want the contact form message to be sent

		define('SMTP_HOSTNAME', ''); // the hostname of the SMTP server
		define('SMTP_PORT', ''); // the port used by your SMTP server
		define('SMTP_USERNAME', ''); // if authentication is required, the username used to login to your SMTP server
		define('SMTP_PASSWORD', ''); // if authentication is required, the password used for login to your SMTP server
		define('SMTP_AUTHENTICATION_TYPE', ''); // if authentication is required, the authentication protocol used by your SMTP server

		// add extra parameters from $_POST for both alt body and msg html
		$subject = $name = $extra_parameters_alt_body = $extra_parameters_msg_html = '';
		if (!empty($_POST)) {
			$extra_parameters_alt_body = "";
			$extra_parameters_msg_html = "";

			$extra_parameters = array();
			foreach ($_POST as $key => $value) {
				preg_match('/(^[^0-9]+)([0-9]+$)/', $key, $matches);
				switch ($matches[1]) {
					case 'subject':
						$subject = trim($value);
					break;
					case 'email':
						$email = trim($value);
					break;
					case 'name':
						$name = trim($value);
					break;
				}

				if (trim($value) != '') {
					$extra_parameters[$matches[2]] = array(
						'key' => $matches[1],
						'value' => trim($value)
					);
				}
			}
			ksort($extra_parameters);

			foreach ($extra_parameters as $extra_parameter) {
				$extra_parameters_alt_body .= "\r\n{$extra_parameter['key']}: ".strip_tags($extra_parameter['value']);
				$extra_parameters_msg_html .= "<tr><td>{$extra_parameter['key']}</td><td>{$extra_parameter['value']}</td></tr>";
			}
		}

		// depending on the PHP version and smtp settings, include the right PHPMailer class
		$mailer = null;
		switch (true) {
			case (int)PHP_VERSION == 4:
				require_once(dirname(__FILE__)."/phpmailer/php4/class.phpmailer.php");
				$mailer = new PHPMailer();
			break;
			case SMTP_HOSTNAME !== '':
				require_once(dirname(__FILE__)."/phpmailer/class.phpmailer.php");
				$mailer = new PHPMailer();
			break;
			default:
				require_once(dirname(__FILE__)."/phpmailer/class.phpmailer-lite.php");
				$mailer = new PHPMailerLite();
			break;
		}


		// prepare the mailer object: mail server settings
		if (SMTP_HOSTNAME !== '') {
			$mailer->IsSMTP();
			//$mailer->SMTPDebug = 2;
			if (SMTP_USERNAME === '' && SMTP_PASSWORD === '') {
				$mailer->SMTPAuth = true;
				if (SMTP_AUTHENTICATION_TYPE !== '') {
					$mailer->SMTPSecure = SMTP_AUTHENTICATION_TYPE;
				}
				$mailer->Host = SMTP_HOSTNAME;

				if (SMTP_PORT !== '') {
					$mailer->Port = SMTP_PORT;
				}

				$mailer->Username = SMTP_USERNAME;
				$mailer->Password = SMTP_PASSWORD;
			}
		} else {
			$mailer->IsMail();
		}

		// prepare the mailer object: email data
		if ((int)PHP_VERSION == 4) {
			$mailer->From = $email;
			$mailer->FromName = !empty($name) ? $name : '';
		} else {
			$mailer->SetFrom($email, !empty($name) ? $name : '');
		}

		if ((int)PHP_VERSION >= 4) {
			$mailer->CharSet = 'UTF-8';
		}

		$mailer->Subject = $subject;
		$mailer->AddAddress(EMAIL_RECIPIENT, '');
		$mailer->AddReplyTo($email, !empty($name) ? $name : '');
		$mailer->AltBody = "\r\n{$extra_parameters_alt_body}"; // IP: {$_SERVER['REMOTE_ADDR']}
		$mailer->MsgHTML("<table>{$extra_parameters_msg_html}</table>"); // <tr><td>IP</td><td>{$_SERVER['REMOTE_ADDR']}</td></tr>

		// send the email
		if ($mailer->Send()) {
			echo 'SUCCESS';
		} else {
			echo 'ERROR';
		}
	}

?>